precision	mediump float;

uniform		sampler2D texture_diffuse;

varying vec4     v_colour;
varying vec2     v_uv;

void main()
{
	vec4 col = texture2D( texture_diffuse, v_uv );
	float fScaled = col.w * 16.0;
	float fLum = fract(fScaled);
	float fAlpha = (fScaled - fLum) / 16.0;
	gl_FragColor = vec4(col.xyz, (1.0+fLum)*fAlpha);
}
